<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreDucumentUploadRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        return [
            'name'        => 'required|string|max:191',
            'role'        => 'required|string|max:191',
            'description' => 'nullable|string',
            // Accept common doc/image/PDF types; adjust as needed
            'document'    => 'required|file|max:10240|mimes:pdf,jpg,jpeg,png,webp,gif,doc,docx,xls,xlsx,csv,txt',
        ];
    }
}
