<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateCustomerRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        $userId = $this->user()->id ?? 0;
        $id = $this->route('customer'); // route model binding id

        return [
            'customer_id' => [
                'sometimes','required','integer',
                Rule::unique('customers','customer_id')
                    ->where(fn($q)=>$q->where('created_by',$userId))
                    ->ignore($id),
            ],
            'email' => [
                'sometimes','nullable','email','max:191',
                Rule::unique('customers','email')
                    ->where(fn($q)=>$q->where('created_by',$userId))
                    ->ignore($id),
            ],
            'name'   => 'sometimes|nullable|string|max:191',
            'tax_number' => 'sometimes|nullable|string|max:191',
            'contact'    => 'sometimes|nullable|string|max:191',
            'avatar'     => 'sometimes|nullable|string|max:100',
            'is_active'  => 'sometimes|nullable|boolean',

            // Billing
            'billing_name'    => 'sometimes|nullable|string|max:191',
            'billing_country' => 'sometimes|nullable|string|max:191',
            'billing_state'   => 'sometimes|nullable|string|max:191',
            'billing_city'    => 'sometimes|nullable|string|max:191',
            'billing_phone'   => 'sometimes|nullable|string|max:191',
            'billing_zip'     => 'sometimes|nullable|string|max:191',
            'billing_address' => 'sometimes|nullable|string',

            // Shipping
            'shipping_name'    => 'sometimes|nullable|string|max:191',
            'shipping_country' => 'sometimes|nullable|string|max:191',
            'shipping_state'   => 'sometimes|nullable|string|max:191',
            'shipping_city'    => 'sometimes|nullable|string|max:191',
            'shipping_phone'   => 'sometimes|nullable|string|max:191',
            'shipping_zip'     => 'sometimes|nullable|string|max:191',
            'shipping_address' => 'sometimes|nullable|string',

            'lang'      => 'sometimes|nullable|string|max:191',
            'balance'   => 'sometimes|nullable|numeric',
        ];
    }
}
