<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateSettingRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        $userId = $this->user()->id ?? 0;
        $id     = $this->route('setting'); // numeric id from route model binding

        return [
            'name'  => [
                'sometimes','required','string','max:191',
                Rule::unique('settings','name')
                    ->where(fn($q) => $q->where('created_by', $userId))
                    ->ignore($id),
            ],
            'value' => ['sometimes','nullable'],
        ];
    }
}
