<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class UpdateVenderRequest extends FormRequest
{
    public function authorize(): bool { return true; }

    public function rules(): array
    {
        $userId = $this->user()->id ?? 0;
        $id     = $this->route('vender'); // id from route model binding

        return [
            'vender_id' => [
                'sometimes','required','integer',
                Rule::unique('venders','vender_id')
                    ->where(fn($q) => $q->where('created_by',$userId))
                    ->ignore($id),
            ],
            'email' => [
                'sometimes','nullable','email','max:191',
                Rule::unique('venders','email')
                    ->where(fn($q) => $q->where('created_by',$userId))
                    ->ignore($id),
            ],
            // same as store, but all 'sometimes'
            'name'                 => 'sometimes|nullable|string|max:191',
            'company_name'         => 'sometimes|nullable|string|max:191',
            'company_legal_name'   => 'sometimes|nullable|string|max:191',
            'company_industry'     => 'sometimes|nullable|string|max:191',
            'company_entity_type'  => 'sometimes|nullable|string|max:191',
            'company_email'        => 'sometimes|nullable|email|max:191',
            'company_website'      => 'sometimes|nullable|string|max:191',
            'registration_number'  => 'sometimes|nullable|string|max:191',
            'vat_number'           => 'sometimes|nullable|string|max:191',
            'company_location_type'=> 'sometimes|nullable|string|max:191',
            'company_address'      => 'sometimes|nullable|string',
            'company_city'         => 'sometimes|nullable|string',
            'company_state'        => 'sometimes|nullable|string',
            'company_zipcode'      => 'sometimes|nullable|string',
            'company_telephone'    => 'sometimes|nullable|string|max:191',
            'tax_number'           => 'sometimes|nullable|string|max:191',
            'password'             => 'sometimes|nullable|string|min:8|max:191',
            'contact'              => 'sometimes|nullable|string|max:191',
            'avatar'               => 'sometimes|nullable|string|max:100',
            'is_active'            => 'sometimes|nullable|boolean',
            'billing_name'         => 'sometimes|nullable|string|max:191',
            'billing_country'      => 'sometimes|nullable|string|max:191',
            'billing_state'        => 'sometimes|nullable|string|max:191',
            'billing_city'         => 'sometimes|nullable|string|max:191',
            'billing_phone'        => 'sometimes|nullable|string|max:191',
            'billing_zip'          => 'sometimes|nullable|string|max:191',
            'billing_address'      => 'sometimes|nullable|string',
            'shipping_name'        => 'sometimes|nullable|string|max:191',
            'shipping_country'     => 'sometimes|nullable|string|max:191',
            'shipping_state'       => 'sometimes|nullable|string|max:191',
            'shipping_city'        => 'sometimes|nullable|string|max:191',
            'shipping_phone'       => 'sometimes|nullable|string|max:191',
            'shipping_zip'         => 'sometimes|nullable|string|max:191',
            'shipping_address'     => 'sometimes|nullable|string',
            'lang'                 => 'sometimes|nullable|string|max:191',
            'balance'              => 'sometimes|nullable|numeric',
        ];
    }
}
