<?php

namespace App\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id'                 => $this->id,
            'name'               => $this->name,
            'email'              => $this->email,
            'type'               => $this->type,
            'plan'               => $this->plan,
            'plan_expire_date'   => $this->plan_expire_date?->toDateString(),
            'requested_plan'     => $this->requested_plan,
            'storage_limit'      => (float) $this->storage_limit,
            'avatar'             => $this->avatar,
            'messenger_color'    => $this->messenger_color,
            'lang'               => $this->lang,
            'default_pipeline'   => $this->default_pipeline,
            'active_status'      => (bool) $this->active_status,
            'delete_status'      => $this->delete_status,
            'mode'               => $this->mode,
            'dark_mode'          => (bool) $this->dark_mode,
            'is_active'          => (bool) $this->is_active,
            'is_email_verified'  => (bool) $this->is_email_verified,
            'email_verified_at'  => optional($this->email_verified_at)->toDateTimeString(),
            'last_login_at'      => optional($this->last_login_at)->toDateTimeString(),
            'created_by'         => $this->created_by,
            'created_at'         => optional($this->created_at)->toDateTimeString(),
            'updated_at'         => optional($this->updated_at)->toDateTimeString(),
        ];
    }
}
