<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Vender extends Model
{
    protected $table = 'venders'; // keep current DB name
    protected $primaryKey = 'id';
    public $incrementing = true;
    protected $keyType = 'int';
    public $timestamps = true;

    protected $fillable = [
        'vender_id','name','email','company_name','company_legal_name','company_industry',
        'company_entity_type','company_email','company_website','registration_number','vat_number',
        'company_location_type','company_address','company_city','company_state','company_zipcode',
        'company_telephone','tax_number','password','contact','avatar','created_by','is_active',
        'email_verified_at','billing_name','billing_country','billing_state','billing_city',
        'billing_phone','billing_zip','billing_address','shipping_name','shipping_country',
        'shipping_state','shipping_city','shipping_phone','shipping_zip','shipping_address',
        'lang','balance','remember_token',
    ];

    protected $hidden = ['password','remember_token'];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'is_active'         => 'boolean',
        'balance'           => 'decimal:2',
    ];

    // Hash password only when a non-empty string is provided
    public function setPasswordAttribute($value): void
    {
        if (is_string($value) && $value !== '') {
            $this->attributes['password'] = bcrypt($value);
        }
    }
}
